/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.gui;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.client.DZ2;
import net.jayjay.dangerzone.container.ItemStack;
import net.jayjay.dangerzone.gui.Gui;
import net.jayjay.dangerzone.item.Item;
import net.jayjay.dangerzone.item.Items;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.texture.Textures;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;

public class GuiIngame
extends Gui {
    private UnicodeFont fontRenderer;
    public int screenWidth = 1280;
    public int screenHeight = 720;

    public GuiIngame() {
        try {
            Font awtFont = Font.createFont(0, DZ2.class.getResourceAsStream("/fonts/font.ttf")).deriveFont(32.0f);
            this.fontRenderer = new UnicodeFont(awtFont);
            this.fontRenderer.addAsciiGlyphs();
            this.fontRenderer.getEffects().add(new ColorEffect(Color.WHITE));
            this.fontRenderer.loadGlyphs();
        }
        catch (IOException e2) {
            System.err.println("Failed to load font.ttf: " + e2.getMessage());
            try {
                Font awtFont = new Font("SansSerif", 0, 32);
                this.fontRenderer = new UnicodeFont(awtFont);
                this.fontRenderer.addAsciiGlyphs();
                this.fontRenderer.getEffects().add(new ColorEffect(Color.WHITE));
                this.fontRenderer.loadGlyphs();
            }
            catch (Exception ex) {
                System.err.println("Failed to load fallback font: " + ex.getMessage());
                this.fontRenderer = null;
            }
        }
        catch (Exception e3) {
            System.err.println("Unexpected error initializing font: " + e3.getMessage());
            this.fontRenderer = null;
        }
    }

    @Override
    public void drawGui(float a2) {
        if (this.fontRenderer == null) {
            System.err.println("Font renderer is null, skipping text rendering");
            return;
        }
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.screenWidth, this.screenHeight, 0.0, 100.0, 300.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -200.0f);
        GL11.glPushMatrix();
        this.drawHotbar();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.drawFpsCounter();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.drawVersionText();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.drawEntityCounter();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.drawCoords();
        GL11.glPopMatrix();
    }

    private void drawHotbar() {
        float slotSize = 64.0f;
        float slotSpacing = 4.0f;
        int hotbarSlots = DZ2.getInstance().ci.inventory.length;
        float totalWidth = (float)hotbarSlots * (slotSize + slotSpacing) - slotSpacing;
        float hotbarX = ((float)this.screenWidth - totalWidth) / 2.0f;
        float hotbarY = (float)this.screenHeight - slotSize - 40.0f;
        int i2 = 0;
        while (i2 < hotbarSlots) {
            float slotX = hotbarX + (float)i2 * (slotSize + slotSpacing);
            GL11.glDisable(3553);
            Tesselator tess = Tesselator.INSTANCE;
            tess.begin(7);
            tess.addVertex(slotX, hotbarY, 0.0f);
            tess.addVertex(slotX + slotSize, hotbarY, 0.0f);
            tess.addVertex(slotX + slotSize, hotbarY + slotSize, 0.0f);
            tess.addVertex(slotX, hotbarY + slotSize, 0.0f);
            tess.flush();
            tess.begin(2);
            if (i2 == DZ2.getInstance().ci.selectedSlot) {
                tess.setColor(0.8f, 0.8f, 0.8f);
            } else {
                tess.setColor(0.4f, 0.4f, 0.4f);
            }
            tess.addVertex(slotX, hotbarY, 0.0f);
            tess.addVertex(slotX + slotSize, hotbarY, 0.0f);
            tess.addVertex(slotX + slotSize, hotbarY + slotSize, 0.0f);
            tess.addVertex(slotX, hotbarY + slotSize, 0.0f);
            tess.flush();
            ItemStack stack = DZ2.getInstance().ci.inventory[i2];
            if (stack != null && !stack.isEmpty()) {
                GL11.glPushMatrix();
                GL11.glTranslatef(slotX + slotSize / 2.0f, hotbarY + slotSize / 2.0f + 8.0f, 0.0f);
                if (stack.isBlock) {
                    Block block = Blocks.getBlockById(stack.id);
                    if (block != null) {
                        GL11.glScalef(64.0f, 64.0f, 64.0f);
                        GL11.glTranslatef(0.5f, 0.375f, -0.5f);
                        GL11.glScalef(-1.0f, -1.0f, 1.0f);
                        Textures.bindNearest(block.getTexturePath(1));
                        GL11.glEnable(3553);
                        tess.begin(7);
                        this.renderBlockHotbar(tess, block, 0, 0, 0);
                        tess.flush();
                        GL11.glDisable(3553);
                    }
                } else {
                    Item item = Items.getItemById(stack.id);
                    if (item != null) {
                        GL11.glScalef(64.0f, 64.0f, 64.0f);
                        GL11.glTranslatef(0.5f, 0.375f, -0.5f);
                        GL11.glScalef(-1.0f, -1.0f, 1.0f);
                        GL11.glEnable(3553);
                        tess.begin(7);
                        Items.getItemById(stack.id).render(tess, DZ2.getInstance().world, 0, 0, 0, 0);
                        tess.flush();
                        GL11.glDisable(3553);
                    }
                }
                GL11.glPopMatrix();
                if (stack.count > 1 && this.fontRenderer != null) {
                    String countText = "" + stack.count;
                    GL11.glPushMatrix();
                    GL11.glTranslatef(slotX + slotSize - 20.0f, hotbarY + slotSize - 20.0f, 0.0f);
                    GL11.glScalef(0.8f, 0.8f, 0.8f);
                    GL11.glEnable(3042);
                    GL11.glBlendFunc(770, 771);
                    this.fontRenderer.drawString(0.0f, 0.0f, countText, new org.newdawn.slick.Color(1.0f, 1.0f, 1.0f));
                    GL11.glDisable(3042);
                    GL11.glPopMatrix();
                }
            }
            ++i2;
        }
        if (this.fontRenderer != null) {
            String healthText = "Health: " + DZ2.getInstance().thePlayer.health;
            GL11.glPushMatrix();
            GL11.glTranslatef(hotbarX + totalWidth + 20.0f, hotbarY + 20.0f, 0.0f);
            GL11.glScalef(1.5f, 1.5f, 1.5f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, healthText, new org.newdawn.slick.Color(1.0f, 0.3f, 0.3f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    private void drawFpsCounter() {
        if (DZ2.getInstance().isDebugMenu) {
            if (this.fontRenderer == null) {
                return;
            }
            String debugText = "FPS: " + DZ2.getInstance().fps + ", " + String.format("%.2f", Float.valueOf(DZ2.getInstance().timer.fps));
            GL11.glPushMatrix();
            GL11.glTranslatef(40.0f, 20.0f, 0.0f);
            GL11.glScalef(2.0f, 2.0f, 2.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, debugText, new org.newdawn.slick.Color(1.0f, 1.0f, 0.5f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    private void drawEntityCounter() {
        if (DZ2.getInstance().isDebugMenu) {
            if (this.fontRenderer == null) {
                return;
            }
            String debugText = "ENTITIES: " + DZ2.getInstance().entityCount;
            GL11.glPushMatrix();
            GL11.glTranslatef(40.0f, 80.0f, 0.0f);
            GL11.glScalef(2.0f, 2.0f, 2.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, debugText, new org.newdawn.slick.Color(1.0f, 1.0f, 0.5f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    private void drawCoords() {
        if (DZ2.getInstance().isDebugMenu) {
            if (this.fontRenderer == null) {
                return;
            }
            String debugText = "null";
            if (DZ2.getInstance().thePlayer != null) {
                debugText = "XYZ: " + DZ2.getInstance().thePlayer.x + " " + DZ2.getInstance().thePlayer.y + " " + DZ2.getInstance().thePlayer.z;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef(40.0f, 140.0f, 0.0f);
            GL11.glScalef(2.0f, 2.0f, 2.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, debugText, new org.newdawn.slick.Color(1.0f, 1.0f, 0.5f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    private void drawVersionText() {
        if (!DZ2.getInstance().isDebugMenu) {
            if (this.fontRenderer == null) {
                return;
            }
            String debugText = DZ2.titleName;
            GL11.glPushMatrix();
            GL11.glTranslatef(40.0f, 20.0f, 0.0f);
            GL11.glScalef(1.5f, 1.5f, 1.5f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, debugText, new org.newdawn.slick.Color(1.0f, 1.0f, 1.0f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    public void renderBlockHotbar(Tesselator tess, Block block, int x, int y, int z) {
        float topBrightness = 1.0f;
        float sideBrightness1 = 0.8f;
        float sideBrightness2 = 0.6f;
        tess.setColor(topBrightness, topBrightness, topBrightness);
        block.renderFace(tess, x, y, z, 0);
        tess.setColor(topBrightness, topBrightness, topBrightness);
        block.renderFace(tess, x, y, z, 1);
        tess.setColor(sideBrightness1, sideBrightness1, sideBrightness1);
        block.renderFace(tess, x, y, z, 2);
        tess.setColor(sideBrightness1, sideBrightness1, sideBrightness1);
        block.renderFace(tess, x, y, z, 3);
        tess.setColor(sideBrightness2, sideBrightness2, sideBrightness2);
        block.renderFace(tess, x, y, z, 4);
        tess.setColor(sideBrightness2, sideBrightness2, sideBrightness2);
        block.renderFace(tess, x, y, z, 5);
    }
}

